/* eslint-disable dot-notation */
/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于文件版本信息
 *
 * 修改:
 *      类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.06.28
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_set_serve_url */
/* exported mc_vers_get_module_version */
/* exported mc_get_module_list_json */
/* exported mc_get_module_info */
/* exported mc_create_module_list */
/* exported mc_vers_get_module_describe_info */
/* exported mc_vers_get_module_child_folders_cnt */
/* exported mc_vers_get_module_detail_info */
/* exported mc_update_module */
/* exported mc_create_module_describe_info */
/* exported mc_create_module_detail_info */
/* exported mc_handle_upgrade_stutus */
/* exported mc_choose_detail */
/* exported mc_record_radio_click_version */
/* exported mc_init_choose_version */
/* exported mc_set_newlist_version_for_all */
/* exported mc_show_progress */
/* exported mc_is_updating_status_edit_btn */


/* global $ */
/* global mc_sdk_param */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置服务地址
 * 参数:
 *    @param {Promise<string>} str_url    模块名称
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.28
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_serve_url(str_url, fun_callback) {
    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("SET_PARAM");
    obj_req.set_func("UPGRADE_URL");
    obj_req.set_param_value("URL", str_url);
    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        var obj_res = new mc_sdk_param();

        obj_res.set_param_clear();
        obj_res.set_json(result);
        var str_error = obj_res.get_param_value("ERROR_CODE");

        fun_callback(str_error);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取每个模块版本信息
 * 参数:
 *    @param {Promise<object>} obj_module_name    模块名称
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.28
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_vers_get_module_version(obj_module_name, fun_callback) {
    var obj_req = new mc_sdk_param();

    var arr_module = Object.keys(obj_module_name);

    var ui_len = arr_module.length;

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("UPGRADE_VERSION");
    for (var idx = 0; idx < ui_len; idx++) {
        var str_module_name = arr_module[idx];

        obj_req.set_param_value(str_module_name, "");
    }
    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        var obj_res = new mc_sdk_param();

        obj_res.set_param_clear();
        obj_res.set_json(result);

        var ui_cnt = obj_res.get_param_cnt();

        for (var id = 0; id < ui_cnt; id++) {
            var str_param_name = obj_res.get_param_name(id);
            var str_param_val = obj_res.get_param_value(str_param_name);

            if ("ERROR_CODE" === str_param_name) {
                continue;
            }
            // str_param_val
            obj_module_name[str_param_name].version = str_param_val;
        }


        fun_callback(obj_module_name);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取本地配置模块数据
 * 参数:
 *    @param {Promise<function>} fun_callback     回调函数
 * 返回：
 *      NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.28
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_module_list_json(fun_callback) {
    var str_url = "/../module_list.json";

    $.get(str_url, function (str_tpl_json, status) {
        if ("success" !== status) {
            fun_callback("");
            return false;
        }

        // 解析配置文件
        var arr_req = mc_trans_to_item_json(str_tpl_json);

        fun_callback(arr_req);
        return true;
    }, "text");
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    转换为发送字串
 * 参数:
 *    @param {Promise<string>} str_ui_json 页面数据字串
 * 返回：
 *    @returns {Promise<string>} 转换后的字串
 * 备注:
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.7.2
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_trans_to_item_json(str_ui_json) {
    if ("string" !== typeof str_ui_json || 0 >= str_ui_json.length) {
        return false;
    }
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    if (!obj_sdk_param.set_json(str_ui_json)) {
        return false;
    }

    var obj_module_list = {};
    var ui_param = obj_sdk_param.get_param_cnt();
    var str_url = "";

    for (let idx = 0; idx < ui_param; idx++) {
        var str_param_name = obj_sdk_param.get_param_name(idx);
        var str_param_val = obj_sdk_param.get_param_value(str_param_name);

        if ("URL" === str_param_name) {
            str_url = str_param_val;
            continue;
        }

        obj_module_list[str_param_name] = {
            "local_address": str_param_val,
            version: "",
            desribe_info: {
                descript: "",
                create_time: "",
                edit_time: ""
            },
            folders_version_cnt: 0,
            folders_version_info: [],
            curr_choose_version: ""
        };
    }

    return [obj_module_list, str_url];
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取每个模块描述信息
 * 参数:
 *    @param {Promise<object>} obj_module_name    模块名称
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    NA

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_vers_get_module_describe_info(obj_module_name, fun_callback) {
    var arr_module = Object.keys(obj_module_name);
    // 模块长度
    var ui_len = arr_module.length;

    mc_req_interface("UPGRADE_MODULE_INFO", obj_module_name, 0, ui_len, arr_module, function (obj_data) {
        fun_callback(obj_data);
    });
    return;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取模块下版本数量
 * 参数:
 *    @param {Promise<object>} obj_module_name    模块名称
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    NA

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_vers_get_module_child_folders_cnt(obj_module_name, fun_callback) {
    var arr_module = Object.keys(obj_module_name);
    // 模块长度
    var ui_len = arr_module.length;

    mc_req_interface("UPGRADE_VERSION_CNT", obj_module_name, 0, ui_len, arr_module, function (obj_data) {
        fun_callback(obj_data);
    });
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取每个模块下的详细信息
 * 参数:
 *    @param {Promise<object>} obj_module_name    模块名称
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    NA

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_vers_get_module_detail_info(obj_module_name, fun_callback) {
    var arr_module = Object.keys(obj_module_name);
    // 模块长度
    var ui_len = arr_module.length;

    mc_req_interface("UPGRADE_VERSION_INFO", obj_module_name, 0, ui_len, arr_module, function (obj_data) {
        fun_callback(obj_data);
    });
    return;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下发请求 (针对只发5个参数以内的请求)
 * 参数:
 *    @param {Promise<String>} func_name    请求函数名
 *    @param {Promise<object>} obj_module_name     界面数据对象
 *    @param {Promise<number>} ui_num     数量id 用来记录当前第几个请求
 *    @param {Promise<number>} ui_module_len    模块长度
 *    @param {Promise<Array>} arr_module    模块数组 用于按顺序下发
 *    @param {Promise<fun_callback>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码
* 备注 :
*    有三个请求 :
*       1.模块信息 UPGRADE_MODULE_INFO
*       2.模块下的版本数量 UPGRADE_VERSION_CNT
*       3.模块下的版本信息 UPGRADE_VERSION_INFO --->特殊处理
*       每次发送请求以2个参数为单位,依次发送直到发完才返回
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_req_interface(func_name, obj_module_name, ui_num, ui_module_len, arr_module, fun_callback) {
    // 设置当前模块下的版本信息索引idx
    var idx_version_info = 0;

    mc_perform_req();

    function mc_perform_req() {
        var obj_req = new mc_sdk_param();

        obj_req.set_param_clear();
        obj_req.set_cmd("GET_PARAM");
        obj_req.set_func(func_name);
        var arr_result = [];
        var obj_req_json = {};

        // 设置参数 针对模块下的版本信息请求特殊处理
        if ("UPGRADE_VERSION_INFO" === func_name) {
            arr_result = mc_handle_req_param_for_version_info(obj_req, ui_num, idx_version_info, arr_module, obj_module_name);
            idx_version_info = arr_result[2];
        } else {
            arr_result = mc_handle_set_req_param(obj_req, ui_num, arr_module, func_name);
            // obj_req_json = arr_result[0];
            // ui_num = arr_result[1];
        }
        obj_req_json = arr_result[0];
        ui_num = arr_result[1];

        $.post("/access_shell", obj_req_json, function (result, status) {
            var obj_res = new mc_sdk_param();

            obj_res.set_param_clear();
            obj_res.set_json(result);

            // 设置对应的数据
            obj_module_name = mc_hangle_get_res_param(obj_module_name, obj_res, func_name);
            //过长则返回
            if (ui_num >= ui_module_len) {
                fun_callback(obj_module_name);
                return;
            }
            mc_perform_req();
            return;
        });
    }
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理生成下发请求json数据
 * 参数:
 *    @param {Promise<object>} obj_req     请求json对象
 *    @param {Promise<number>} ui_num     当前下发的模块idx
 *    @param {Promise<Array>} arr_module     下发的模块
 *    @param {Promise<string>} func_name     下发的接口名称 (用于分别处理数据)

 * 返回：
 *    @return {Promise<string>} obj_req.get_json() obj_req对象的json字串
 * 备注: 统一请求两个两个发
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_handle_set_req_param(obj_req, ui_num, arr_module, func_name) {
    switch (func_name) {
        case "UPGRADE_MODULE_INFO":
            for (var id = 0; 2 > id; id++) {
                var str_module_name_one = arr_module[ui_num];

                if (!str_module_name_one) {
                    continue;
                }

                var str_num = ui_num.toString();

                obj_req.set_param_value(ui_num, "");
                obj_req.set_attr_val(str_num, "NAME", str_module_name_one);
                ui_num += 1;
            }
            break;
        case "UPGRADE_VERSION_CNT":
            for (var id_two = 0; 2 > id_two; id_two++) {
                var str_module_name_two = arr_module[ui_num];

                if (!str_module_name_two) {
                    continue;
                }
                obj_req.set_param_value(str_module_name_two, "");
                ui_num += 1;
            }
            break;

        default:
            break;
    }


    return [obj_req.get_json(), ui_num];
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理获取请求回来的数据
 * 参数:
 *    @param {Promise<object>} obj_module_name    模块名称
 *    @param {Promise<object>} obj_res     请求回来的json字串
 *    @param {Promise<string>} func_name     下发的接口名称 (用于分别处理数据)
 * 返回：
 *    @return {Promise<object>} obj_module_name    模块名称
 * 备注: 变量名后缀 one/two/three 分别代表 UPGRADE_MODULE_INFO/UPGRADE_VERSION_CNT/UPGRADE_VERSION_INFO
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.30
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_hangle_get_res_param(obj_module_name, obj_res, func_name) {
    var ui_len = obj_res.get_param_cnt();

    switch (func_name) {
        case "UPGRADE_MODULE_INFO":

            for (var idx_par_one = 0; idx_par_one < ui_len; idx_par_one++) {
                var str_par_name_one = obj_res.get_param_name(idx_par_one);
                // var str_param_val = obj_res.get_param_value(str_par_name_one);

                if ("ERROR_CODE" === str_par_name_one) {
                    continue;
                }
                var ui_attr_cnt = obj_res.get_attr_cnt(str_par_name_one);

                // obj_module_name[arr_module[ui_num]].desribe_info = {};
                var str_module_req_name = obj_res.get_attr_val(str_par_name_one, "NAME");

                for (var idx_attr_one = 0; idx_attr_one < ui_attr_cnt; idx_attr_one++) {
                    var str_attr_name = obj_res.get_attr_name(str_par_name_one, idx_attr_one);
                    var str_attr_val = obj_res.get_attr_val(str_par_name_one, str_attr_name);

                    str_attr_name = str_attr_name.toLocaleLowerCase();
                    if ("name" === str_attr_name || "error_code" === str_attr_name) {
                        continue;
                    }
                    obj_module_name[str_module_req_name].desribe_info[str_attr_name] = str_attr_val;
                }
            }

            break;
        case "UPGRADE_VERSION_CNT":
            for (var idx_par_two = 0; idx_par_two < ui_len; idx_par_two++) {
                var str_par_name_two = obj_res.get_param_name(idx_par_two);
                var str_par_val_two = obj_res.get_param_value(str_par_name_two);

                // 可能存在没有数量的模块
                if ("ERROR_CODE" === str_par_name_two || !str_par_val_two) {
                    continue;
                }
                obj_module_name[str_par_name_two].folders_version_cnt = Number(str_par_val_two);
            }
            break;
        case "UPGRADE_VERSION_INFO":
            for (var idx_par_three = 0; idx_par_three < ui_len; idx_par_three++) {
                var str_par_name_three = obj_res.get_param_name(idx_par_three);
                // var str_param_val = obj_res.get_param_value(str_par_name_three);

                if ("ERROR_CODE" === str_par_name_three) {
                    continue;
                }
                var ui_attr_cnt_three = obj_res.get_attr_cnt(str_par_name_three);
                // 定义暂时对象
                var obj_temp_data = {
                    create_time: "",
                    edit_time: "",
                    log: "",
                    version: ""
                };

                for (var idx_attr_three = 0; idx_attr_three < ui_attr_cnt_three; idx_attr_three++) {
                    var str_attr_name_three = obj_res.get_attr_name(str_par_name_three, idx_attr_three);
                    var str_attr_val_three = obj_res.get_attr_val(str_par_name_three, str_attr_name_three);

                    str_attr_name_three = str_attr_name_three.toLocaleLowerCase();
                    if ("error_code" === str_attr_name_three || !str_attr_val_three) {
                        continue;
                    }
                    obj_temp_data[str_attr_name_three] = str_attr_val_three;
                }
                str_par_name_three = str_par_name_three.split("|")[0];
                obj_module_name[str_par_name_three].folders_version_info.push(obj_temp_data);
            }
            break;

        default:
            break;
    }


    return obj_module_name;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理生成下发请求json数据
 * 参数:
 *    @param {Promise<object>} obj_req     请求json对象
 *    @param {Promise<number>} ui_num     当前下发的模块idx
 *    @param {Promise<number>} idx_version_info     设置当前模块下的版本信息索引idx
 *    @param {Promise<Array>} arr_module     下发的模块
 *    @param {Promise<string>} obj_module_name     界面数据存储对象

 * 返回：
 *    @return {Promise<string>} obj_req.get_json() obj_req对象的json字串
 * 备注: 针对模块下的版本信息 UPGRADE_VERSION_INFO 请求
 * 逻辑 : ui_num:设定当前下发哪个模块 / idx_version_info:设定当前下发的模块总数量
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.30
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_handle_req_param_for_version_info(obj_req, ui_num, idx_version_info, arr_module, obj_module_name) {
    var str_curr_module = arr_module[ui_num];
    // 获取当前模块下的可下发数量
    var ui_module_info_cnt = obj_module_name[str_curr_module].folders_version_cnt;

    // 超过3个以上的情况 需先减去上次已发的数据 避免重复
    ui_module_info_cnt -= idx_version_info;

    for (var idx = 0; 3 > idx; idx++) {
        if (0 === ui_module_info_cnt) {
            // 此时当前模块下所有参数已发完 发下一个参数
            ui_num += 1;
            idx_version_info = 0;
            break;
        }
        var str_idx_version_info = idx_version_info.toString();
        var str_param_name = str_curr_module + "|" + idx;

        obj_req.set_param_value(str_param_name, "");
        obj_req.set_attr_val(str_param_name, "MODULE", str_curr_module);
        obj_req.set_attr_val(str_param_name, "INDEX", str_idx_version_info);
        idx_version_info += 1;
        ui_module_info_cnt -= 1;
    }


    return [obj_req.get_json(), ui_num, idx_version_info];
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    更新指定的版本
 * 参数:
 *     @param { Promise<object> } obj_data 界面数据
 *     @param { Promise<string> } str_type 更新/状态 (上传版本 / 获取状态识别)
 *     @param { Promise<Function> } fun_callback 回调函数
 * 返回：
 *      NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_update_module(obj_data, str_type, fun_callback) {
    var arr_module_name = Object.keys(obj_data);
    var ui_len = arr_module_name.length;
    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("UPGRADE_UPDATE");

    for (var idx = 0; idx < ui_len; idx++) {
        var str_module_name = arr_module_name[idx];
        var str_version = obj_data[str_module_name].curr_choose_version;

        obj_req.set_param_value(str_module_name, str_version);
        if ("UPGRADE" === str_type) {
            // 更新时 若未选中模块版本则添加此模块更新状态
            if (!str_version) {
                continue;
            }
            var str_update_address = obj_data[str_module_name].local_address;

            obj_req.set_attr_val(str_module_name, str_type, str_update_address);
        } else {
            // 查看状态
            obj_req.set_attr_val(str_module_name, str_type, "");
        }
    }


    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_status = {
            STATUS: "",
            OPT_CNT: "",
            OPT_IDX: "",
            OUT_ERROR_CODE: "",
            IN_ERROR_CODE: ""
        };
        var obj_all_status = {
            WEB_ADDON_WIN: "",
            WEB_FRAME_WIN: "",
            HAL_WIN: "",
            WEB_UI: "",
            WEB_ENTRY_WIN: ""
        };
        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        var ui_param_cnt = obj_res.get_param_cnt();

        for (var id = 0; id < ui_param_cnt; id++) {
            var str_param_name = obj_res.get_param_name(id);
            var str_param_val = obj_res.get_param_value(str_param_name);

            if ("ERROR_CODE" === str_param_name) {
                obj_status.OUT_ERROR_CODE = str_param_val;
                continue;
            }

            var ui_attr_cnt = obj_res.get_attr_cnt(str_param_name);

            for (var key = 0; key < ui_attr_cnt; key++) {
                var str_attr_name = obj_res.get_attr_name(str_param_name, key);
                var str_attr_val = obj_res.get_attr_val(str_param_name, str_attr_name);

                if ("ERROR_CODE" === str_attr_name) {
                    obj_status.IN_ERROR_CODE = str_attr_val;
                    continue;
                }
                obj_status[str_attr_name] = str_attr_val;
            }
            obj_all_status[str_param_name] = obj_status;
        }


        fun_callback(obj_all_status);
        return;
    });
}


/* --------------------------------------------------------创建dom--------------------------------------------------------------------- */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    生成模块列表dom数据
 * 参数:
 *    @param {Promise<object>} obj_data    模块名称
 * 返回：
 *    @return {Promise<string>} str_dom    dom
 * 并显示第一个
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_create_module_list(obj_data) {
    var arr_module = Object.keys(obj_data);
    var str_dom = "";

    for (var idx = 0; idx < arr_module.length; idx++) {
        var str_module_name = arr_module[idx];
        var str_module_describ = obj_data[str_module_name].desribe_info.descript;
        var str_module_time = obj_data[str_module_name].desribe_info.edit_time;
        var str_module_version = obj_data[str_module_name].version;
        // 选中第一个
        var str_show_first_class = "mc_show_module_list";

        if (0 !== idx) {
            str_show_first_class = "";
        }

        var arr_module_lang_id = ["MC_LANG_VERS_ADDON", "MC_LANG_VERS_FRAME", "MC_LANG_VERS_WIN", "MC_LANG_VERS_UI", "MC_LANG_VERS_ENTRY"];


        //校验数据&转换数据
        // str_module_time = mc_handle_time(str_module_time);
        str_module_version = mc_handle_show_data(str_module_version);
        str_module_describ = mc_handle_show_data(str_module_describ);

        var str_temp_dom = "<div class='mc_module_list_content flex_box_vertical each_item " + str_show_first_class + " ' value='" + str_module_name + "' onclick='mc_module_list_each_item(this);'><div class='mc_module_list_item_top flex_box_horizontal'><div class='mc_each_item_title' control_type lang_id='" + arr_module_lang_id[idx] + "'></div><div class=' mc_moduelist_bottom_box'>" + str_module_time + "</div></div><div class='mc_module_list_item_bottom flex_box_horizontal'><div class='mc_module_list_item_left_describe'>" + str_module_describ + "</div><div class='mc_moduelist_bottom_box'>" + str_module_version + "</div></div><div class='mc_progress_bar_each flex_box_vertical' value='" + str_module_name + "'><div class='mc_progress_bar'><div class='mc_progress_insert_bar'></div></div><div class='mc_progress_bottom flex_box_horizontal'><div class='mc_progress_word_info flex_box_horizontal'><div class='mc_progress_status' lang_id control_type></div><div class='mc_progress_bag_cnt'></div></div><div class='mc_progress_kps'></div></div></div></div>";

        str_dom += str_temp_dom;
    }


    return str_dom;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    生成描述信息dom数据
 * 参数:
 *    @param {Promise<object>} obj_data    模块存储数据
 *    @param {Promise<string>} str_name    模块名称
 * 返回：
 *    @return {Promise<string>} str_dom    dom

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_create_module_describe_info(obj_data, str_name) {
    if (!str_name) {
        return false;
    }
    var obj_curr_module_data = obj_data[str_name].desribe_info;

    if (!obj_curr_module_data.create_time && !obj_curr_module_data.descript && !obj_curr_module_data.edit_time) {
        return false;
    }

    var str_dom = "";

    var str_describe = obj_curr_module_data.descript;
    var str_edit_time = obj_curr_module_data.edit_time;

    var str_module_lang_id = mc_handle_module_name_lang(str_name);


    //校验数据&转换数据
    // str_edit_time = mc_handle_time(str_edit_time);
    str_describe = mc_handle_show_data(str_describe);

    var str_temp = "<div class='flex_box_horizontal mc_all_item'><div class='mc_describe_list_item_left flex_box_auto_size'><div class='mc_each_item_title' control_type lang_id='" + str_module_lang_id + "'></div></div><div class='mc_module_list_item_right'><div>" + str_edit_time + "</div></div></div><div class='mc_all_item mc_describhe_content'>" + str_describe + "</div>";

    str_dom += str_temp;


    return str_dom;
}

function mc_handle_module_name_lang(str_name) {
    var str_lang_id = "";

    switch (str_name) {
        case "WEB_ADDON_WIN":
            str_lang_id = "MC_LANG_VERS_ADDON";
            break;
        case "WEB_FRAME_WIN":
            str_lang_id = "MC_LANG_VERS_FRAME";
            break;
        case "HAL_WIN":
            str_lang_id = "MC_LANG_VERS_WIN";
            break;
        case "WEB_UI":
            str_lang_id = "MC_LANG_VERS_UI";
            break;
        case "WEB_ENTRY_WIN":
            str_lang_id = "MC_LANG_VERS_ENTRY";
            break;

        default:
            break;
    }

    return str_lang_id;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    生成详细信息dom数据
 * 参数:
 *    @param {Promise<object>} obj_data    模块存储数据
 *    @param {Promise<string>} str_name    模块名称
 * 返回：
 *    @return {Promise<string>} str_dom_detail    dom

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.30
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_create_module_detail_info(obj_data, str_name) {
    if (!str_name) {
        return false;
    }
    if (0 === obj_data[str_name].folders_version_info.length) {
        return false;
    }

    var arr_detail_all = obj_data[str_name].folders_version_info;
    var ui_len_detail_item = arr_detail_all.length;

    var str_dom_detail = "";
    var arr_version = [];

    // ui_len_detail_item =6
    for (var idx = 0; ui_len_detail_item > idx; idx++) {
        // 当前选中的模块的详细信息
        var obj_module_data = arr_detail_all[idx];

        var str_radio_id = "detail";


        var str_version = obj_module_data.version;
        var str_log = obj_module_data.log;
        var str_edit_time = obj_module_data.edit_time;

        //校验数据&转换数据
        // str_edit_time = mc_handle_time(str_edit_time);
        str_version = mc_handle_show_data(str_version);
        str_log = mc_handle_show_data(str_log);

        str_radio_id += idx;

        var str_temp_dom = "<div class='flex_box_horizontal mc_detail_each_item' ><div class='mc_detail_left_top' onclick='mc_scroll_content(this)' scroll='false'><div class='flex_box_horizontal mc_all_item'><div class=' flex_box_auto_size'><div class='mc_each_item_title'>" + str_version + "</div></div><div class='mc_detail_list_item_right'><div>" + str_edit_time + "</div></div></div><div class='mc_module_list_item_left_describe mc_all_item mc_detail_log'>" + str_log + "</div></div><input onclick='mc_radio(this)' type='radio' id='" + str_radio_id + "' name='detail' class='detail_radio' /></div>";

        str_dom_detail += str_temp_dom;
        arr_version.push(str_version);
    }


    return [str_dom_detail, arr_version];
}

/* --------------------------------------------------------创建dom--------------------------------------------------------------------- */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理接口时间
 * 参数:
 *    @param {Promise<string>} str_val    模块存储数据
 * 返回：
 *    @return {Promise<string>} str_time    dom

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.30
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_handle_time(str_val) {
    if (!str_val) {
        return "????";
    }

    var str_time = "";
    var arr_time = str_val.split(" ");
    var str_date = arr_time[0];
    var str_h_m_s = arr_time[1];
    var str_period = arr_time[2];

    var arr_date = str_date.split("/");

    str_time = arr_date[2] + "-" + arr_date[0] + "-" + arr_date[1];

    var arr_hms = str_h_m_s.split(":");

    if ("PM" === str_period || "pm" === str_period) {
        arr_hms[0] = Number(arr_hms[0]) + 12;
    }

    str_time = str_time + " " + arr_hms[0] + ":" + arr_hms[1];
    return str_time;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理一些获取不到的数据
 * 参数:
 *    @param {Promise<string>} str    模块存储数据
 * 返回：
 *    @return {Promise<string>} str    str

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.01
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_handle_show_data(str) {
    if (!str) {
        return "????";
    }
    return str;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理当前模块下的细节部分 显示选中某个
 * 参数:
 *    @param {Promise<Object>} obj_data    界面数据
 *    @param {Promise<string>} str_curr_click_module
 *    @param {Promise<object>} arr_curr_v    版本从上到下依次顺序
 * 返回：
 *    @return {Promise<object>} obj_data    界面数据
 * 备注:
 *      有版本 根据记录选中对应 无记录则 再根据是否有版本 进行判断 无则用最新 有则用当前版本的
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_choose_detail(obj_data, str_curr_click_module, arr_curr_v) {
    var str_curr_version = obj_data[str_curr_click_module].version;
    var str_choose_version = obj_data[str_curr_click_module].curr_choose_version;
    var ui_target = 0;
    var str_final_version = "";

    // 存在记录且有的情况
    if (str_choose_version) {
        if (-1 !== arr_curr_v.toString().indexOf(str_choose_version)) {
            // 且里面有
            str_final_version = str_choose_version;
        } else {
            // 判断当前是否有版本
            if (str_curr_version) {
                if (arr_curr_v.toString().indexOf(str_curr_version)) {
                    // 有
                    str_final_version = str_curr_version;
                } else {
                    // 用最新版本
                }
            } else {
                // 用最新版本
            }
        }
    } else {
        // 判断当前是否有版本
        if (str_curr_version) {
            if (arr_curr_v.toString().indexOf(str_curr_version)) {
                // 有
                str_final_version = str_curr_version;
            } else {
                // 用最新版本
            }
        } else {
            // 用最新版本
        }
    }

    for (var idx = 0; idx < arr_curr_v.length; idx++) {
        if (str_final_version === arr_curr_v[idx]) {
            ui_target = idx;
        }
    }

    var dom_radio = document.getElementsByClassName("detail_radio");

    dom_radio[ui_target].checked = true;
    // 获取当前选中的版本
    obj_data[str_curr_click_module].curr_choose_version = arr_curr_v[ui_target];
    return obj_data;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    记录当前模块所选的版本信息
 * 参数:
 *    @param {Promise<Object>} str_curr_click_module    界面数据
 *    @param {Promise<string>} event
 *    @param {Promise<object>} obj_module_list    版本从上到下依次顺序
 * 返回：
 *    @return {Promise<object>} obj_data    界面数据

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_record_radio_click_version(str_curr_click_module, event, obj_module_list) {
    var str_click_version = event.parentElement.getElementsByClassName("mc_each_item_title")[0].innerText;

    obj_module_list[str_curr_click_module].curr_choose_version = str_click_version;

    return obj_module_list;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    初始化obj存储数据的选中版本参数
 * 参数:
 *    @param {Promise<Object>} obj_data    界面数据
 * 返回：
 *    @return {Promise<object>} obj_data    界面数据
 * 备注:
 *      记录当前 所选的版本 模块有版本则用显示的,但若列表没有 则用最新
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_init_choose_version(obj_data) {
    var arr_module_list = Object.keys(obj_data);

    for (var id = 1; id < arr_module_list.length; id++) {
        var str_module_name = arr_module_list[id];
        var str_curr_v = obj_data[str_module_name].version;
        var arr_each_module_all_version = [];
        var ui_version_module = obj_data[str_module_name].folders_version_cnt;

        // 获取当前描述所有版本
        for (var idx = 0; idx < ui_version_module; idx++) {
            if (!obj_data[str_module_name].folders_version_info[idx]) {
                continue;
            }
            arr_each_module_all_version.push(obj_data[str_module_name].folders_version_info[idx].version);
        }
        if (0 === arr_each_module_all_version.length) {
            continue;
        }
        // 模块有版本则用显示的,但若列表没有 则用最新
        if (str_curr_v) {
            if (-1 !== arr_each_module_all_version.toString().indexOf(str_curr_v)) {
                obj_data[str_module_name].curr_choose_version = str_curr_v;
            } else {
                obj_data[str_module_name].curr_choose_version = arr_each_module_all_version[0];
            }
        } else {
            obj_data[str_module_name].curr_choose_version = arr_each_module_all_version[0];
        }
    }


    return obj_data;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置所有模块为最新版本
 * 参数:
 *    @param {Promise<string>} str_curr_click_module    界面数据
 *    @param {Promise<Object>} obj_module_list    界面数据
 * 返回：
 *    @return {Promise<object>} obj_module_list    界面数据
 * 备注:
 *     设置所有参数选择为当前最新版本
 *     设置当前显示模块为最新版本
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_newlist_version_for_all(str_curr_click_module, obj_module_list) {
    var arr_module_list = Object.keys(obj_module_list);

    for (var idx = 0; idx < arr_module_list.length; idx++) {
        var str_module_name = arr_module_list[idx];

        if (0 === obj_module_list[str_module_name].folders_version_info.length) {
            continue;
        }

        obj_module_list[str_module_name].curr_choose_version = obj_module_list[str_module_name].folders_version_info[0].version;
    }

    // 跳转到最新版本
    var dom_radio = document.getElementsByClassName("detail_radio");

    if (dom_radio[0]) {
        dom_radio[0].checked = true;
    }

    return obj_module_list;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理进度条数据
 * 参数:
 *    @param {Promise<object>} obj_data    界面数据
 * 返回：
 *    @return {Promise<boolean>} b_done    全员结束
 * 备注:
 *     设置所有参数选择为当前最新版本
 *     设置当前显示模块为最新版本
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_show_progress(obj_data) {
    // 判断是否全员结束
    var b_done = true;
    // 模块列表参数
    var arr_list = Object.keys(obj_data);
    var ui_list = arr_list.length;
    // 进度条dom
    var arr_dom = document.getElementsByClassName("mc_progress_bar_each");
    var ui_dom = arr_dom.length;
    var arr_result_boolean = [];

    for (var idx = 0; idx < ui_list; idx++) {
        var str_curr_module = arr_list[idx];

        for (let key = 0; key < ui_dom; key++) {
            // 获取对应模块列表下的进度条的value
            var str_curr_progress = arr_dom[key].getAttribute("value");

            if (str_curr_progress === str_curr_module) {
                var dom_curr = arr_dom[key].children[0].children[0];
                var obj_data_progress = obj_data[str_curr_module];
                var str_status_code = obj_data_progress.STATUS;
                var ui_opt_idx = Number(obj_data_progress.OPT_IDX);
                var ui_opt_cnt = Number(obj_data_progress.OPT_CNT);
                var out_error = obj_data_progress.OUT_ERROR_CODE;
                var in_error = obj_data_progress.IN_ERROR_CODE;

                // 只有有值且不是4时才继续跑 否则都视为结束
                if ("4" !== str_status_code && str_status_code) {
                    arr_result_boolean.push(false);
                } else {
                    arr_result_boolean.push(true);
                }

                // 改变当前进度条长度

                if (0 !== ui_opt_cnt) {
                    var ui_percent_bag = ui_opt_idx / ui_opt_cnt;
                    var str_change_width = dom_curr.offsetWidth;

                    str_change_width = 239 * ui_percent_bag;
                    if (239 < str_change_width) {
                        str_change_width = 239;
                    }
                    dom_curr.style.width = str_change_width + "px";
                    //dom_curr添加一个随机背景颜色
                    dom_curr.style.background = "#cccccc";
                }

                // 显示下载包量及状态 及kps
                var arr_children_dom = arr_dom[key].children[1].children;

                if ("0x00000000" !== out_error && out_error) {
                    arr_children_dom[0].children[0].innerHTML = "请求ERROR_CODE : " + out_error;
                } else if ("0x00000000" !== in_error && in_error) {
                    arr_children_dom[0].children[0].innerHTML = "参数ERROR_CODE : " + in_error;
                } else {
                    var str_progress_wod_info = " ( " + ui_opt_idx + " / " + ui_opt_cnt + " ) ";

                    arr_children_dom[0].children[0].setAttribute("lang_id", mc_handle_status(str_status_code));
                    arr_children_dom[0].children[1].innerText = str_progress_wod_info;
                    arr_children_dom[1].innerText = obj_data_progress.DOWNLOAD_AVG_KPS + " Kps";
                }

                break;
            }
        }
    }

    // 判断当前是否需要再请求 有一个任务未结束都要继续获取状态
    for (var id = 0; id < arr_result_boolean.length; id++) {
        if (!arr_result_boolean[id]) {
            b_done = false;
            break;
        }
    }

    return b_done;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理显示状态
 * 参数:
 *    @param {Promise<string>} str_status_code    界面数据
 * 返回：
 *    @return {Promise<string>} str_lang    翻译
 * 备注:
 *     设置所有参数选择为当前最新版本
 *     设置当前显示模块为最新版本
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_handle_status(str_status_code) {
    var str_lang = "";

    switch (str_status_code) {
        case "0":
            str_lang = "MC_LANG_VERS_UPGRADE_PREPARE";
            break;
        case "1":
            str_lang = "MC_LANG_VERS_UPDATING";
            break;
        case "2":
            str_lang = "MC_LANG_VERS_USE_UPGARDE_FLODERS";
            break;
        case "3":
            str_lang = "MC_LANG_VERS_CLAEN_RESULT";
            break;
        case "4":
            str_lang = "MC_LANG_VERS_UPGRADE_END";
            break;

        default:
            break;
    }
    return str_lang;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断当前是否更新状态 修改dom表现
 * 参数:
 *    @param {Promise<boolean>} b_update    当前是否处于更新状态 true更新中/false结束更新
 * 返回：
 *    NA
 * 备注:
 *     设置所有参数选择为当前最新版本
 *     设置当前显示模块为最新版本
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_is_updating_status_edit_btn(b_update) {
    var arr_btn = $(".icon-send-box-param");
    var ui_len = arr_btn.length;

    for (let id = 0; id < ui_len; id++) {
        if (b_update) {
            $(arr_btn[id]).css({ "opacity": "0.5", "pointer-events": "none" });
        } else {
            $(arr_btn[id]).css({ "opacity": "1", "pointer-events": "auto" });
        }
    }
}
